function [A,Ainv] = rzpfastA(alpha,beta,DD,Kinv,DDinv)
%% [A,Ainv] = rzpfastA(alpha,beta,DD,K,DDinv)
% Function to be mexified. It comprises the fast version for the system
% matrix (A) calculation. The matrix A calculation is the equivalent to the
% one performed in fgess, however it only uses the necessary steps,
% speeding up the computation.
%
% An example of the use of the function and how to retrieve the matrix A
% from fgess follow:
%
% [L,LX] = rzp(tok,shot,t);
%
% %% Using rzpfastA
% A = rzpfastA(LX.Ia,LX.Iu,LX.Iy,LX.Ip,LX.rIp,LX.bp,...
%         L.Mey,L.Mee,L.Re,LX.Rp,L.RBrye,L.RBzye,L.drx,L.dzx,L.ny,L.np,L.ne,L.icde);
%
% %% Using fgess
% sys = fgess(L);
% A = sys.A;
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

%#codegen  
%% Generate A matrix in continuous time representation
if nargin < 4
  Kinv = eye(2,2,'single');
  DDinv = eye(size(DD),'single');
end

A = -DD + (beta*alpha*beta')*DD;

if nargout > 1
  Ainv = -DDinv + DDinv*(beta*Kinv*beta');
end

end