function [L,LX,LY] = rzp(tok,shot,t,varargin)
%RZIp - LINEAR EVOLUTIVE INTREGRAL FORCE BALANCE SOLVER
% Evolves plasma (Rc,Zc,Ip only), coil and vessel currents
% [L,LX,LY] = rzp(tok,shot,t,varargin)
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

assert(ischar(tok),'tok must be a string');
tok = lower(tok); % tok: 'tcv' 'ids'
meqpath(mfilename,tok); % check required files and add path if necessary
assert(isnumeric(shot)||ischar(shot)||iscell(shot),'shot must be numeric (for database) or string (for file)');
if nargin>=3, assert(~mod(numel(varargin),2),'varargin must come in ''parameter'',value pairs'); end

% Tokamak specific functions
rzpptok = str2func(['rzpp' tok]);
rzpgtok = str2func(['rzpg' tok]);

% Algorithm configuration parameters, geometry and anciliary data
P = rzpptok(shot(1),varargin{:}); % parameters from sources
G = rzpgtok(shot(1),P);  % geometry from sources
P = rzpp(P);   % Assemble all parameters
G = rzpg(G,P); % Assemble geometry
L = rzpc(P,G); % Consolidate parameters
  
if nargout >= 2
  assert(isnumeric(t) || ~isempty(t),'time must be a numeric and nonempty');
  % Get inputs data for simulation
  LX = rzpx(tok,t,L);
  % compute linearization and initial condition
  L = rzpl(L,meqxk(LX,1));
end

if nargout >= 3  
  % Time stepper
  LY = rzpt(L,LX);
end

end
