%RTCIMEX  Isoflux contouring
% [A,DAN,R,Z,IR] = RTCIMEX(A,ERO,EZO,F,FQ,CR,CZ,OPY,FO,OPO,DAP,RO,CRO,ZO,CZO)
% updates the previous guess for A(rh,th), the distance from the points
% (RO,ZO) to the flux surface with normalised coordinate rh~=0 at poloidal
% angle th. 
% R=RO+A*CRO, Z=RO+A*CZO, IR=1/R, 
% ERO=(RO-r(1))/dr, EZO=(ZO-z(1))/dz, with r(1),z(1) the smallest r,z grid points
% F(z,r) flux map, FQ(rh) the flux value for rh,
% CRO=-cos(th), CR=CRO/dr, CZO=sin(th), CZ=CZO/dz
% OPY is the mapping of the different plasma domains
% FO is the value of the flux at the origin of each segment
% OPO is the domain identifier at the origin of each segment
% DAP limits the update, DAN is the largest update.
%
% For details, see: [MEQ-redbook], Section "Wall Gaps" 
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [varargout] = rtcimex(a,er0,ez0,Fx,F,c,s,Opy,Fo,Opo,dap,r,coq,z,soq)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 [varargout{1:nargout}] = rtcimexm(a,er0,ez0,Fx,F,c,s,Opy,Fo,Opo,dap,r,coq,z,soq);
end
