%QINTMEX N-point quadratic interpolation (6<=N<=9)
% [FI,BRI,BZI,BRRI,BRZI,BZRI,BZZI] = qintmex(RX,ZX,FX,RI,ZI,INM)
% Interpolates flux FX on grids RX,ZX to vector of points RI,ZI.
% INM: Coefficients for the interpolation such that
% P = INM*Y. INM [6,N] is calculated by QINTC.m
% Y is the vector of N values of FX on neighbouring points.
% FX can have multiple slices.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Quadratic function
% y = c0 + c1*dr + c2*dz + c3*2*dr*dz + c4*dr^2 + c5*dz^2;
% fit 6 coefficients to n points (n=6 to 9)
%
% y7 y3 y5
% y2 y0 y1
% y6 y4 y8
%
% y(  0,  0) = y0;
% y( dr,  0) = y1;
% y(-dr,  0) = y2;
% y(0  , dz) = y3;
% y(0  ,-dz) = y4;
% y(dr , dz) = y5;
% y(-dr,-dz) = y6;
% y(-dr, dz) = y7;
% y( dr,-dz) = y8;
%
%
% This gives equations:
%
% c0                   = y0;
% c0 + c4*dr^2 + c1*dr = y1;
% c0 + c4*dr^2 - c1*dr = y2;
% c0 + c5*dz^2 + c2*dz = y3;
% c0 + c5*dz^2 - c2*dz = y4;
% c0 + c1*dr + c2*dz + c3*2*dr*dz + c4*dr^2 + c5*dz^2 = y5
% c0 - c1*dr - c2*dz + c3*2*dr*dz + c4*dr^2 + c5*dz^2 = y6
% c0 - c1*dr + c2*dz - c3*2*dr*dz + c4*dr^2 + c5*dz^2 = y7
% c0 + c1*dr - c2*dz - c3*2*dr*dz + c4*dr^2 + c5*dz^2 = y8

% derivatives and fields are then found analytically (COCOS=17)
% Br = -1/(2*pi*r) * dFdz;
% Bz =  1/(2*pi*r) * dFdr;
%
% Brr,Brz,Bzr,Bzz by further derivatives.
%
% The matrix for interpolating Y = [y0..yn] to P=[c0..c5] is pre-computed
% in qintc.m
function varargout = qintmex(varargin)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 [varargout{1:nargout}] = qintmexm(varargin{:});
end
