function meqvis(t1,rx,zx,Fx,F,Fb,...
  r,z,rz_plotopt,...
  bar_data,bar_col,bar_text,...
  figname,hax)
 %MEQVIS  Visualisation function for debugging
 %
 % Inputs:
 % t1: title string
 % rx,zx,Fx: r,z, coordinates and flux function
 % F,Fb: contours of Fx to plot, boundary flux value
 % r,z,rz_plotopt: cell array of additional r,z arrays to plot with plot(r{k},z{k},rz_plotopt{k})
 % bar_data,bar_col,bar_text: cell array of data to show in bar graph, with colors col and title text
 % figname: figure name
 % hax: axis handle
 % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
 
 % Cross-section
 if nargin > 10 && ~isempty(bar_data)
   ax = axes('Position',[.1,.1,.35,.8]);
 elseif nargin>=14
   ax = hax;
 else
   ax = gca;
 end

 contourf(ax,rx,zx,Fx,F)
 colormap(ax,'jet')

 if ~isempty(t1), title(ax,t1); end
 
 hold(ax,'on');
 if ~isnan(Fb)
   % thicker line for LCFS
 FFb = repmat(Fb,1,max(3-numel(Fb),1)); % multi-FB
 contour(ax,rx,zx,Fx,FFb,'linewidth',2,'linecolor','k');
 end
 for k = 1:length(r)
  plot(ax,r{k},z{k},rz_plotopt{k})
 end
 hold(ax,'off'), axis(ax,'equal','off');
 xlim(ax,rx([1 end])), ylim(ax,zx([1 end]))
 
 % Bars
 if nargin > 10 && ~isempty(bar_data)
  ax=axes('Position',[.55,.1,.35,.8]);
  nb = length(bar_data);
  hold(ax,'on');
  n = 0;
  for k = 1:nb
   bb = bar_data{k};
   B = sqrt(mean(bb.^2,'omitnan'));
   if B > 1, B = log10(B)+1; end
   l = abs(bb) > 1; bb(l) = sign(bb(l)).*(log10(abs(bb(l)))+1);
   barh(n+(1:numel(bb)),bb,1,'FaceColor',bar_col{k},'edgecolor','none');
   plot(ax,B*[-1 1;-1 1],[n+0.5;n+length(bb)+.5],'Linestyle','-','Color',bar_col{k})
   n = n + length(bb);
  end
  hold off
  set(ax,'xlim',[-2 2],'xtick',-2:2,'xticklabel',{'-10' '-1' '0' '1' '10'},'xgrid','on',...
   'ylim',[0 n+1],'ytick',[],'ydir','reverse')
  title(ax,bar_text)
 end
 
 if nargin>=13 && ~isempty(figname)
   set(gcf,'Name',figname);
 end
end
