% Printing progress bar to terminal
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function meqprogress(it,nt,reset,displaynr)
% progress bar display
% it: iteration counter
% nt: total iterations
% reset: flag for resetting state
% displaynr: optional display of a string or scalar instead of a dot.
if nargin<3; reset=false; end
if nargin<4; dstr = '.';
else
  assert(numel(displaynr)==1,'can only display a scalar');
  if isnumeric(displaynr), dstr = sprintf('%d',displaynr);  % string to be displayed
  elseif ~ischar(displaynr), error('displaynr must be numeric or char')
  end
end

persistent clearBar currentLength
if isempty(clearBar) || reset
  clearBar = 0;
  currentLength = 0;
end

strDotsMaximum = 50;
nDots = min(floor(it/nt*strDotsMaximum),strDotsMaximum);
dotOut = sprintf('[%-*s] %d/%d',strDotsMaximum,repmat(dstr,1,nDots),it,nt);
if clearBar
  S = repmat('\b',1,currentLength);
  fprintf(S);
end
fprintf(dotOut);
clearBar = 1;
currentLength = numel(dotOut);
if it==nt
  fprintf('\n'); % end
end
end