function meqmsge(mode,callfct,tok,t,it,shot,txt,mnem)
% Display errors/warnings/information during meqt run-time
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Display full iteration state 
if     numel(it)==1, it = sprintf('%d' ,it);
elseif numel(it)==2, it = sprintf('%d.%d',it(1),it(2));
else,                error('MEQMSGE:sizeIt', 'Unsupported number of elements in it');
end

msgID = sprintf('%s:%s',callfct,mnem);
if isscalar(t)
  msg = sprintf('%s#%d %6.4fs/%s: %s',tok,shot,t,it,txt);
else
  msg = sprintf('%s#%d %6.4f-%6.4fs/%s: %s',tok,shot,t(1),t(end),it,txt);
end

switch mode
  case 'i'
    disp(msg); %#ok<*DSPS,*SPWRN,*SPERR>
  case 'w'
    s = warning('off','backtrace');
    warning(msgID,msg);
    warning(s);
  case 'e'
    ME = MException(msgID,msg);
    throwAsCaller(ME);
end
end
