function argoutc = meqargoutc(argout,argoutc_)
% MEQARGOUTC Parses string for additional output argument specification
%
%   ARGOUTC = MEQARGOUTC(ARGOUT,ARGOUTC_)
%
% Parses cell array of strings ARGOUT assuming {'[file:]fld[=exp]',...} format.
% The output ARGOUTC is a cell array of structures with fields FILE, FLD and EXP.
% If FILE is not specified, the expression will be evaluated when LY is
% assembled by the main code file (e.g. LIUT,FBTT...)
% The processing of ARGOUT is appended to the preexisting list ARGOUTC_
% when provided.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

argout = reshape(cellstr(argout),1,[]); % Convert to cell row vector
% Parse argout parameter with value {'[file:]fld[=exp]' ...}
argoutc = regexp(argout,'(?<file>\w+:)*(?<fld>\w+)=*(?<exp>.+)*','names');
for ii = 1:numel(argoutc)
  if ~isempty(argoutc{ii}.file)
    % Remove colon
    argoutc{ii}.file = argoutc{ii}.file(1:end-1);
    if ~ismember(argoutc{ii}.file,{'fgeF','meqpost','meqpostq'})
      error('meqargoutc:unsupportedFile','File %s is not supported for additional argument specification',argoutc{ii}.file);
    end
  end
  if isempty(argoutc{ii}.exp)
    % Case with no expression provided
    argoutc{ii}.exp = argoutc{ii}.fld; % fld=fld
  end
end

% Append to preexisting list
if nargin>1
  argoutc = [argoutc_,argoutc];
end

end
