function LY = meqLYdot(LY,LYp)
% MEQLYDOT Computation of time derivatives of Bm,Ff,Fn measurements,
% respectively Um,Uf,Un
%
% Inputs
%  LY,LYp: current and previous LY structure.
% Output: 
%  LY: Input LY with appended Um,Uf,Un fields.
%
% NB: If LY.t = LYp.t Um,Uf and Un will be vectors of zeros.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
if LY.t == LYp.t
  LY.Um = zeros(size(LY.Bm));
  LY.Uf = zeros(size(LY.Ff));
  LY.Un = zeros(size(LY.Fn));
else
  idt = 1./(LY.t-LYp.t);
  LY.Um = (LY.Bm-LYp.Bm)*idt;
  LY.Uf = (LY.Ff-LYp.Ff)*idt;
  LY.Un = (LY.Fn-LYp.Fn)*idt;
end
end