function [dIydr,dIydz] = meqIyfd(Iy,Tzd,Trd)
% [dIydr,dIydz] = meqIyfd(Iy,Tzd,Trd)
% Calculate the spatial derivative in the r and z direction of Iy using
% second order finite difference and assuming the value of Iy to be 0
% outside the grid
%
% Input: Iy: plasma current distribution in the y grid
%        Tzd: tridiagonal matrix for the finite difference in the z
%        direction such that dIydz = Tzd*Iy
%        Trd: tridiagonal matrix for the finite difference in the r
%        direction such that dIydr = Iy*Trd
%
% Output: dIydr: finite difference derivarive wrt r
%         dIydz: finite difference derivarive wrt z
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
    
  %derivatives wrt r
  dIydr = Iy*Trd;
  
  %derivatives wrt z
  dIydz = Tzd*Iy;
end