function A = csint_helper(rho,d)
% CSINT_HELPER helper function for cubic spline evaluation
%
%   A = CSINT_HELPER(RHO,D)
%
% Considering a 1D cubic spline with equally spaced knots T
% and coefficients C. The evaluation of the D-th derivative
% at T(k)+RHO (with 0<=RHO<dT) is
%   V = A*C(k-3:k)
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
switch d
  case 0
    %
    c0 = rho;
    c3 = 1-rho;
    %
    c1 = (1/2)*(c0.*(2-rho)+c3.*(rho+1));
    c0 = (1/2)*(c0.*   rho );
    c3 = (1/2)*(c3.*(1-rho));
    %
    c2 = (1/3)*(c1.*(2-rho)+c3.*(rho+2));
    c1 = (1/3)*(c0.*(3-rho)+c1.*(rho+1));
    c0 = (1/3)*(c0.*   rho );
    c3 = (1/3)*(c3.*(1-rho));
    
    A = [c3,c2,c1,c0];
  case 1
    %
    c0 = rho;
    c3 = 1-rho;
    %
    c1 = (1/2)*(c0.*(2-rho)+c3.*(rho+1));
    c0 = (1/2)*(c0.*   rho );
    c3 = (1/2)*(c3.*(1-rho));
    %
    c2 = c3-c1;
    c1 = c1-c0;
    c0 = c0   ;
    c3 =   -c3;
    
    A = [c3,c2,c1,c0];
  case 2
    %
    c0 = rho;
    c3 = 1-rho;
    %
    c1 = c3-c0;  % 1-2*rho
    c0 = c0   ;  % rho
    c3 =   -c3;  % rho-1
    %
    c2 = c3-c1;  % 3*rho-2
    c1 = c1-c0;  % 1-3*rho
    c0 = c0   ;  % rho
    c3 =   -c3;  % 1-rho
    
    A = [c3,c2,c1,c0];
  case 3
    %
    c0 =  1;
    c3 = -1;
    %
    c1 = c3-c0;  % -2
    c0 = c0   ;  %  1
    c3 =   -c3;  %  1
    %
    c2 = c3-c1;  %  3
    c1 = c1-c0;  % -3
    c0 = c0   ;  %  1
    c3 =   -c3;  % -1
    
    A = [c3,c2,c1,c0];
end
end
