classdef fgeF_perf < matlab.perftest.TestCase
  % Tests for fgeF operator
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    data
  end

  properties(ClassSetupParameter)
    grid = struct('ny_1000',[32,16],'ny_2000',[32,32],'ny_4000',[64,32]);
    usecs = struct('false',false,'true',true);
    shot = struct('circular',1,'double_null',3,'doublet',82);
  end

  methods(TestClassSetup)
    function fgeFTestSetup(testCase,grid,usecs,shot)
      
      if usecs
        PP = {'icsint',true,'ilim',3};
      else
        PP = {'icsint',false,'ilim',1};
      end
      
      [L,LX] = fgs('ana',shot,0,'nr',grid(1),'nz',grid(2),PP{:});

      LXt = LX;
      LYp = LX;

      x = L.LX2x(LX);

      testCase.data = {x,L,LXt,LYp};
    end
  end

  properties(TestParameter)
    jacx = struct('false',false,'true',true);
  end
  
  methods (Test)
    function perf_fgeF_eval(testCase,jacx)
      % Test single operator evaluation

      [x,L,LXt,LYp] = deal(testCase.data{:});
      
      F = @(x,opts) fgeF(x,L,LXt,LYp,opts);
      opts = optsF('dojacx',jacx);
      
      while (testCase.keepMeasuring)
        [~,~,~,~,~] = F(x,opts);
      end 
    end
  end
end
