function opts = optsF(varargin)
% OPTSF default value for F options
%
% OPTS = OPTSF(VARARGIN)
%
% Generate a structure for use by functions passed to SOLVEF. Optional arguments in name-value pairs
% provide values to the different fields which are false by default.
%
% Each function as input to solveF must have a signature
%   [res,LY,Jx,Ju,Jxdot,rowmask] = F(x,...)
%
% List of fields:
%  - dopost: compute post processing LY
%  - doplot: produce some debugging plots
%  - dojacx: compute Jx (jacobian matrix dres/dx)
%  - dojacu: compute Ju (jacobian matrix dres/du)
%  - dojacxdot: compute Jxdot (jacobian matrix dres/dxdot = -dt*dres/dxp)
%  - dojacF: return a function handle for Jx
%
% See also: solveF fgeF fgsF_GS
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
opts = struct('dodisp',false,'dopost',false,'doplot',false,'dojacx',false,'dojacu',false,'dojacxdot',false,'dojacF',false);

if mod(nargin,2), error('optsF:nargin','optsF arguments should come in name,value pairs');end
for ii=1:2:nargin
  opts.(varargin{ii}) = varargin{ii+1};
end
 
end
