function varargout = n2k(varargin)
% N2K utility for handling concatenation of different quantities
%   [kNa,kNb,kNb,...,nN] = n2k(na,nb,nc,...)
% If a vector N is made of the concatenation of several subvectors a,b,c...
% of size na, nb, nc then N2K computes kNa,kNb,kNc...nN such that N is of
% size nN and we have N(kNa) = a, N(kNb) = b, N(kNc) = c ...
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
varargout = cell(1,nargin+1);
varargout{end} = 0;
for k = 1:nargin
  varargout{k} = varargout{end}+(1:varargin{k});
  varargout{end} = varargout{end} + varargin{k};
end
end