%MKMEQH  Generates include file MEQ.H
% MKMEQH(FILES) generates the include file MEQ.H for LIBMEQ
%
% Files in LIBMEQ are written without specifying the floating point precision.
% We instead use macros from the C preprocessor to generate copies of each
% function in single and double precision (with different names).
%
% This function identifies all function declarations in LIBMEQ and adds
% declarations with both types in the generated file MEQ.H. This allows to use
% these functions in MEX-files and C S-functions without declaring them
% explicitely again.
%
% Used by MAKEFILE.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function mkmeqh(files)

fh = fopen('include/meq.h','w');
% header
fprintf(fh,'/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */\n');
fprintf(fh,'/* Generated by mkmeqh.m %s */\n# include "meqh.h"\n',datestr(now)); %#ok<TNOW1,DATST> % lint suggestion to use datetime() does not work in octave
fprintf(fh,'#ifdef __cplusplus\nextern "C" {\n#endif\n');

files = strsplit(files,' ');
for myfile = files
 file = myfile{:};
 [~,grep] = system(['grep -e "\<[sd]' file '[0-9]*\>" mexc/*.c csfc/*.c -l -s']);
 grep(grep==10) = ',';
 fprintf('Doing %12s in %s\n',file,grep(1:end-1))
 ff = fopen(['libmeq/' file '.c'],'r');
 t = fread(ff,Inf,'*char')';
 fclose(ff);
 % Match expression starting at the beginning of a line with a word followed by FLT_NAME(word)( ... )
 % followed by some space and either an open curly bracket or a semicolon
 t = regexp(t,'\n(\w+\s+FLT_NAME\(\w+\)\(.*?\))\s*(\{|;)','tokens');
 for k = 1:length(t)
  tn = regexprep(t{k}{1},'\s+',' '); % Replace all white space by a regular space
  % Replace CPP macros with full names for single and double precision
  patterns = {'FLT_NAME\((\w+)\)','FLT'};
  ts = regexprep(tn,patterns,{'s$1',' float'});
  td = regexprep(tn,patterns,{'d$1','double'});
  fprintf(fh,'%s;\n%s;\n',ts,td);
 end
end
fprintf(fh,'#ifdef __cplusplus\n}\n#endif\n');
fclose(fh);
