%VIZRMEX  Compute volume integrals
%
% This is the MATLAB equivalent implementation of libmeq/vizr.c.
% A more detailed help is available in VIZRMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [Wp,Ft0,Vp] = vizrmexm(Fx,Opy,ry,iry,rBt,drx,dzx)

drdz = drx/dzx; dzdr = dzx/drx; ds = drx*dzx;
[nzx,nrx] = size(Fx);

yp = 0; yi = 0; yv = 0;
for jj = 2:nrx-1
  yr = 0;
  yz = 0;
  ni = 0; % counter of how many grid points on this R contain plasma
  for ii = 2:nzx-1
    iD = Opy(ii-1,jj-1);
    if iD>0
      x = (Fx(ii  ,jj+1) - Fx(ii  ,jj-1));
      yr = yr + x*x;
      x = (Fx(ii+1,jj  ) - Fx(ii-1,jj  ));
      yz = yz + x*x;
      ni = ni + 1;
    end
  end
  yp = yp + (yr*dzdr + yz*drdz)*iry(jj-1);
  yi = yi + ni*iry(jj-1);
  yv = yv + ni* ry(jj-1);
end

Wp  = 15831.43494411528*yp; % 1/(16*pi*mu0)
Ft0 = rBt*ds*yi;
Vp  = 6.283185307179586*ds*yv; % Volume = 2pi\int RdRdZ = 2*pi*sum(ni*Ri)*dr*dz