%RTCIMEX  Isoflux contouring
%
% This is the MATLAB equivalent implementation of libmeq/rtci.c.
% A more detailed help is available in RTCIMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [a,dan,rq,zq,irq] = rtcimexm(a,er0,ez0,Fx,F,c,s,Opy,Fo,Opo,dap,r,coq,z,soq)
 [nz,nr] = size(Fx);
 no = length(c);
  
 er = er0 + a.*c; jr = min(floor(max(er,0)),nr-2);
 ez = ez0 + a.*s; jz = min(floor(max(ez,0)),nz-2);
 frq = er - jr;
 fzq = ez - jz;
 kq = nz*jr + jz + 1; % no +1 in C
 f0 = Fx(kq); f1 = Fx(kq+nz)-f0; f2 = Fx(kq+1)-f0; f3 = Fx(kq+nz+1)-f0-f1-f2;
 f4 = fzq.*f3 + f1;
 fq = repmat(F,no,1);
 df = (frq.*f3+f2).*s + f4.*c;
 fw = f0 + frq.*f4 + fzq.*f2;
 % Proximity to domain boundary
 kq = (nz-2)*(jr-1) + jz; % jz - 1 in C
 Op0 = zeros(no,1,'int8'); Op1 = Op0; Op2 = Op0; Op3 = Op0;
 mask = (jr>0    & jz>0   ); Op0(mask) = Opy(kq(mask)     ); % lower left
 mask = (jr<nr-2 & jz>0   ); Op1(mask) = Opy(kq(mask)+nz-2); % lower right
 mask = (jr>0    & jz<nz-2); Op2(mask) = Opy(kq(mask)   +1); % upper left
 mask = (jr<nr-2 & jz<nz-2); Op3(mask) = Opy(kq(mask)+nz-1); % upper right
 zz = cat(3,Op0,Op1,Op2,Op3) - Opo;
 % Classify point with:
 %  ptype=0 means all neighbours are in the same domain as origin
 %  ptype=1 means some neighbours are in another domain
 %  ptype=2 means all neighbours are in another domain
 ptype = zeros(size(fq));
 ptype(Opo & any(zz,3)) = 1; % Adding Opo disables domain checks for gaps
 ptype(Opo & all(zz,3)) = 2;
 da = (fq-fw)./df;
 da(df==0) = 0;
 % Wrong domain (if in plasma domain)
 mask = (ptype == 2);
 if any(mask)
   da(mask) = -dap;
 end
 % Derivative reverses close to boundary (wrong branch of X-point)
 mask = df.*(Fo - fq) > 0 & ptype == 1;
 if any(mask)
   da(mask) = -dap;
 end
 % Escape regions of incorrect gradient
 mask = df.*(Fo - fq) > 0 & ptype == 0;
 if any(mask)
   da(mask) = sign((fw(mask)-fq(mask)).*df(mask))*dap;
 end
 da = min(max(da,-dap),dap);
 %
 a = abs(a + da);
 dan = max(abs(da(:)));
 if nargout > 2
  rq = r + a.*coq;
  zq = z + a.*soq;
  irq = 1 ./ rq;
 end
end
