%IPMHMEX  Fit FE with Interior Point Method
%
% This is the MATLAB equivalent implementation of libmeq/ipmh.c.
% A more detailed help is available in IPMHMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [Ie,Jh,st] = ipmhmexm(Ahd,Aed,Ahe,Aeh,Ahh,uAhh,Yd,Ie0,Jh0,sIp,nit,tol)
 Gh1 = Ahd*Yd;
 Ie1 = Aed*Yd;
 Gh  = Gh1 + Ahe*Ie0;
 Gh1 = Gh1 + Ahe*Ie1;
 z = repmat(sIp,length(Jh0),1);
 for k = 1:nit
  % Do a single IPM iteration
  [Jh,z,st] = ipm4mexm(uAhh,Gh,sIp,Jh0,z,tol*1e6,1,false);
  st = st && (norm(Jh0-Jh,Inf) < tol);
  if st, break, end
  Gh = Gh1 + Ahh*Jh;
  Jh0 = Jh;
 end
 Ie = Ie1 + Aeh*Jh;
end
