%FSG2MEX  Flux surface geometrical integrals 2
%
% This is the MATLAB equivalent implementation of libmeq/fsg2.c.
% A more detailed help is available in FSGIMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [VQ,AQ] = fsg2mexm(aq,rA,crq,doq)

 C1 = 0.5*doq;
 C2 = 2*pi*doq;

 qaq = aq.*aq;
 s1q = sum(qaq.*(rA/2 + aq.*crq/3));
 s2q = sum(qaq                    );

 VQ  = [0 C2*s1q].';
 AQ  = [0 C1*s2q].';
end
