%FBNDMEX find the flux and the limiting point of the LCFS
%
% This is the MATLAB equivalent implementation of libmeq/fbnd.c.
% A more detailed help is available in FBNDMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

function [FB,rB,zB,lB,lX,kB] = fbndmexm(Fl,rl,zl,FX,rX,zX,FN)

 if (FN > 0) % Ip < 0
   [FBX,kX] = min([FN;FX]); kX = kX-1;
   [FBl,kl] = min([FN;Fl]); kl = kl-1;
   lX = FBX < FBl;
 else        % Ip > 0
   [FBX,kX] = max([FN;FX]); kX = kX-1;
   [FBl,kl] = max([FN;Fl]); kl = kl-1;
   lX = FBX > FBl;
 end
 if (kX && lX)
   FB = FBX;
   rB = rX(kX);
   zB = zX(kX);
   lB = 1;
   kB = kX;
 elseif kl
   FB = FBl;
   rB = rl(kl);
   zB = zl(kl);
   lB = 1;
   kB = kl;
 else
   FB = FN;
   rB = 0;
   zB = 0;
   lB = 0;
   kB = 0;
 end

end