%CIZRMEX  Compute custom volume integrals
%
% This is the MATLAB equivalent implementation of libmeq/cizr.c.
% A more detailed help is available in CIZRMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [IVQD] = cizrmexm(Fx,Opy,Vy,dsx,FNQ,F0,F1)

[nzx,nrx] = size(Fx);

nV = size(Vy,2);
nQ = numel(FNQ);
nD = numel(F0);
% Get inverse of flux variation over all domains
idF = (F1-F0);
idF(idF~=0) = 1./idF(idF~=0);
Vy = reshape(Vy,nzx-2,nrx-2,nV);

% Initialize all integrals
IVQD = zeros(nQ,nD,nV);

for jj = 2:nrx-1
  for ii = 2:nzx-1
    % Check domain of current point
    iD = Opy(ii-1,jj-1);
    if iD>0 && iD<=nD
      FN = (Fx(ii,jj) - F0(iD))*idF(iD);
      % Find iQ such that FNQ(iQ-1)<FN<=FNQ(iQ);
      iQ = 1;
      while (iQ <= nQ && FNQ(iQ)<FN)
        iQ = iQ+1;
      end
      % If flux is between F0 and F1 (it always should)
      if iQ<=nQ
        % Add its contribution to corresponding integrals
        IVQD(iQ,iD,:) = IVQD(iQ,iD,:) + Vy(ii-1,jj-1,:)*dsx;
      end
    end
  end
end

% cumulative sum
for iD = 1:nD
  for iQ = 2:nQ
    IVQD(iQ,iD,:) = IVQD(iQ-1,iD,:) + IVQD(iQ,iD,:);
  end
end
