%BINTMEX 4-point bilinear interpolation
%
% This is the MATLAB equivalent implementation of libmeq/bint.c.
% A more detailed help is available in BINTMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function Fi = bintmexm(Fx,k,c)

nz = size(Fx,1);
Fi = Fx(k+1   ).*c(1,:)' + ...
     Fx(k+nz+1).*c(2,:)' + ...
     Fx(k+nz+2).*c(3,:)' + ...
     Fx(k+2   ).*c(4,:)';

end
