%BBOXMEX  Domain bounding box
%
% This is the MATLAB equivalent implementation of libmeq/bbox.c.
% A more detailed help is available in BBOXMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [B] = bboxmexm(O,x,y)

[nx,ny] = size(O);

init = true;
for jj = 1:ny
  yv = y(jj);
  for ii = 1:nx
    xv = x(ii);
    if O(ii,jj)
      if (init)
        xa = xv; xb = xv;
        ya = yv; yb = yv;
        init = false;
      else
        if     (xv < xa), xa = xv;
        elseif (xv > xb), xb = xv;end
        if     (yv < ya), ya = yv;
        elseif (yv > yb), yb = yv;end
      end
    end
  end
end
if (init)
  B = zeros(1,4);
else
  B = [xa,ya,xb,yb];
end