/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [FI,BRI,BZI,BRRI,BRZI,BZZI] = qint(RX,ZX,FX,RI,ZI,INM) */

# define MEXNAME qintmex

# define FI   pout[0]
# define BRI  pout[1]
# define BZI  pout[2]
# define BRRI pout[3]
# define BRZI pout[4]
# define BZRI pout[5]
# define BZZI pout[6]

# define RX   prhs[0]  /* double, def size=nr */
# define ZX   prhs[1]  /* double, def size=nz */
# define FX   prhs[2]  /* double, def size=nz*nr*nF */
# define RI   prhs[3]  /* double, def size=ni */
# define ZI   prhs[4]  /* double, size=ni */
# define INM  prhs[5]  /* double, def size=[*,n], size=[6,n] */

 int ni, nr, nz, n;
 int mri, nri;
 int ntot, nx;
  
 CHECK_NARGIN_EQ(6);

 ni = mxGetNumberOfElements(RI);
 nr = mxGetNumberOfElements(RX);
 nz = mxGetNumberOfElements(ZX);
 n  = mxGetN(INM);
 nx = nr*nz;
 /* If this is not an integer, then the check of numel(FX) will fail */
 ntot = mxGetNumberOfElements(FX)/nx;

 CHECK_DOUBLE(RX);
 CHECK_DOUBLE(ZX);
 CHECK_DOUBLE(FX);
 CHECK_NUMEL(FX,nx*ntot);
 CHECK_DOUBLE(RI);
 CHECK_DOUBLE(ZI);
 CHECK_NUMEL(ZI,ni);
 CHECK_DOUBLE(INM);
 CHECK_NROWS(INM,6);

 CHECK_NARGOUT_LE(7);

 /* Additionally check that (nr*nz) is either:
  *  - the first dimension of FX
  *  - the product of the first 2 dimensions of FX */
 const mwSize *dims = mxGetDimensions(FX); /* Will be of size 2 at least */
 if ((dims[0] != nx) && (dims[0]*dims[1] != nx))
   mexErrMsgIdAndTxt(MEXARGS_STR(MEXNAME)":inputSize",MEXARGS_STR(MEXNAME)" expects FX to be an array with either the first dimension or the combined two first dimensions of size nz*nz(%d)",nx);

 mxArray *pout[7] = {NULL};
 
 mri = mxGetM(RI);
 nri = mxGetN(RI);
 
 const mwSize ridims[3] = {mri,nri,ntot};
 FI   = mxCreateNumericArray(3,ridims,mxDOUBLE_CLASS,mxREAL);
 BRI  = mxCreateNumericArray(3,ridims,mxDOUBLE_CLASS,mxREAL);
 BZI  = mxCreateNumericArray(3,ridims,mxDOUBLE_CLASS,mxREAL);
 BRRI = mxCreateNumericArray(3,ridims,mxDOUBLE_CLASS,mxREAL);
 BRZI = mxCreateNumericArray(3,ridims,mxDOUBLE_CLASS,mxREAL);
 BZRI = mxCreateNumericArray(3,ridims,mxDOUBLE_CLASS,mxREAL);
 BZZI = mxCreateNumericArray(3,ridims,mxDOUBLE_CLASS,mxREAL);

 dqint(mxGetPr(FI), mxGetPr(BRI), mxGetPr(BZI), mxGetPr(BRRI), mxGetPr(BRZI), mxGetPr(BZRI), mxGetPr(BZZI),
       mxGetPr(RX), mxGetPr(ZX), mxGetPr(FX), mxGetPr(RI), mxGetPr(ZI), mxGetPr(INM),
       ni, nr, nz, n, ntot);


 ASSIGN_PLHS;
}
