/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

  /* nfd = nfdbmex(f) */

# define MEXNAME nfdbmex

# define NFD pout[0]

# define F   prhs[0] /* double, def size=[nx,ny,ntot] */

  CHECK_NARGIN_EQ(1);

  CHECK_DOUBLE(F);

  CHECK_NARGOUT_LE(1);

  mxArray *pout[1] = {NULL};
  
  int nd = mxGetNumberOfDimensions(F);
  const mwSize *dims = mxGetDimensions(F);
  int nx = (int)dims[0];
  int ny = (int)dims[1];
  int ntot = nd>2 ? (int)dims[2] : 1;

  NFD = mxCreateDoubleMatrix(2*(nx-2)+2*(ny-2),ntot,mxREAL);
  dnfdb(mxGetPr(NFD),mxGetPr(F),nx,ny,ntot);

  ASSIGN_PLHS;
}
