/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [x,z,kt,st] = ipm4mex(H,c,a,x0,z0,tol,nit,verb) */

# define MEXNAME ipm4mex

# define X   pout[0]
# define Z   pout[1]
# define KT  pout[2]
# define ST  pout[3]

# define H   prhs[0]  /* double, size=n*(n+1)/2 */
# define C   prhs[1]  /* double, def size=n */
# define A   prhs[2]  /* numeric, scalar */
# define X0  prhs[3]  /* double, size=n */
# define Z0  prhs[4]  /* double, size=n */
# define TOL prhs[5]  /* numeric, scalar */
# define NIT prhs[6]  /* numeric, scalar */
# define VRB prhs[7]  /* logical, scalar */

 CHECK_NARGIN_EQ(8);

 int n = mxGetNumberOfElements(C);

 CHECK_DOUBLE(H);
 CHECK_NUMEL(H,n*(n+1)/2);
 CHECK_DOUBLE(C);
 CHECK_NUMERIC(A);
 CHECK_SCALAR(A);
 CHECK_DOUBLE(X0);
 CHECK_NUMEL(X0,n);
 CHECK_DOUBLE(Z0);
 CHECK_NUMEL(Z0,n);
 CHECK_NUMERIC(NIT);
 CHECK_SCALAR(NIT);
 CHECK_NUMERIC(TOL);
 CHECK_SCALAR(TOL);
 CHECK_LOGICAL(VRB);
 CHECK_SCALAR(VRB);

 CHECK_NARGOUT_LE(4);

 mxArray *pout[4] = {NULL};

 int nit = mxGetScalar(NIT);
 int kt = 0;
 meq_bool stat = meq_false;
 double *w  = (double *)mxCalloc(n*(n+1)/2+4*n,sizeof(double));
 X = mxCreateDoubleMatrix(n,1,mxREAL);
 Z = mxCreateDoubleMatrix(n,1,mxREAL);
 
 dipm4(mxGetPr(X), mxGetPr(Z), &kt, &stat, 
       mxGetPr(H), mxGetPr(C), mxGetScalar(A), mxGetPr(X0), mxGetPr(Z0),
       mxGetScalar(TOL), nit, mxIsLogicalScalarTrue(VRB), w, n);

 KT = mxCreateDoubleScalar((double)kt);
 ST = mxCreateLogicalScalar(stat);
 mxFree(w);

 ASSIGN_PLHS;
}
