/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /*  [VQ,AQ] = fsg2(aq,rA,crq,doq) */

# define MEXNAME fsg2mex

# define VQ   pout[ 0]
# define AQ   pout[ 1]

# define aq    prhs[ 0]  /* double, def size=[noq,npq] */
# define rA    prhs[ 1]  /* numeric, scalar */
# define crq   prhs[ 2]  /* double, size=noq */
# define doq   prhs[ 3]  /* numeric, scalar */

 CHECK_NARGIN_EQ(4);

 int noq = mxGetM(aq), npq = mxGetN(aq);

 CHECK_DOUBLE(aq);
 CHECK_NUMERIC(rA);
 CHECK_SCALAR(rA);
 CHECK_DOUBLE(crq);
 CHECK_NUMEL(crq,noq);
 CHECK_NUMERIC(doq);
 CHECK_SCALAR(doq);

 CHECK_NARGOUT_LE(2);

 mxArray *pout[2] = {NULL};

 VQ  = mxCreateDoubleMatrix(npq+1,1,mxREAL);
 AQ  = mxCreateDoubleMatrix(npq+1,1,mxREAL);
 dfsg2(mxGetPr(VQ), mxGetPr(AQ),
       mxGetPr(aq), mxGetScalar(rA), mxGetPr(crq),
       mxGetScalar(doq), npq, noq);

 ASSIGN_PLHS;
}
