/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* function [Fl,drFl,dzFl] = fl4pmex(Fx,kl,cl,FN) */

# define MEXNAME fl4pmex

# define   FL pout[0]
# define DRFL pout[1]
# define DZFL pout[2]

# define FX prhs[0]  /* double, def size=[nz,*] */
# define KL prhs[1]  /* int32, def size=nl */
# define CL prhs[2]  /* double, size=4*nl */
# define FN prhs[3]  /* numeric, scalar */

 CHECK_NARGIN_EQ(4);

 int nz = mxGetM(FX), nl = mxGetNumberOfElements(KL);

 CHECK_DOUBLE(FX);
 CHECK_INT32(KL);
 CHECK_DOUBLE(CL);
 CHECK_NUMEL(CL,4*nl);
 CHECK_NUMERIC(FN);
 CHECK_SCALAR(FN);

 CHECK_NARGOUT_LE(3);

 mxArray *pout[3] = {NULL};

 FL   = mxCreateDoubleMatrix(nl, 1, mxREAL);
 DRFL = mxCreateDoubleMatrix(nl, 1, mxREAL);
 DZFL = mxCreateDoubleMatrix(nl, 1, mxREAL);
 dfl4p(mxGetPr(FL), mxGetPr(DRFL), mxGetPr(DZFL),
       mxGetPr(FX), (int *)mxGetData(KL), mxGetPr(CL), mxGetScalar(FN), nl, nz);

 ASSIGN_PLHS;
}
