/* CIZRMEX Compute custom plasma cross-section integrals
 *   See description in cizrmex.m */

/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [IVQD] = cizrmex(Fx,Opy,Vy,dsx,FNQ,F0,F1) */

# define MEXNAME cizrmex

# define IVQD pout[0] 

# define FX   prhs[0]  /* double, def size=[nz,nr] */
# define OPY  prhs[1]  /* int8, size=(nz-2)*(nr-2) */
# define VY   prhs[2]  /* double, def size=[(nz-2)*(nr-2),nV] */
# define DS   prhs[3]  /* numeric, scalar */
# define FNQ  prhs[4]  /* double, def size=nQ */
# define F0   prhs[5]  /* double, def size=nD */
# define F1   prhs[6]  /* double, size=nD */

 CHECK_NARGIN_EQ(7);

 int nz=mxGetM(FX), nr=mxGetN(FX),
     nV=mxGetN(VY),
     nQ=mxGetNumberOfElements(FNQ),
     nD=mxGetNumberOfElements(F0);
 
 int ny = (nz-2)*(nr-2);

 CHECK_DOUBLE(FX);
 CHECK_INT8(OPY);
 CHECK_NUMEL(OPY,ny);
 CHECK_DOUBLE(VY);
 CHECK_NROWS(VY,ny);
 CHECK_NUMERIC(DS);
 CHECK_SCALAR(DS);
 CHECK_DOUBLE(FNQ);
 CHECK_DOUBLE(F0);
 CHECK_DOUBLE(F1);
 CHECK_NUMEL(F1,nD);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1] = {NULL};
 
 const mwSize dims[3] = {nQ,nD,nV};
 IVQD = mxCreateNumericArray(3,dims,mxDOUBLE_CLASS,mxREAL);

 dcizr(mxGetPr(IVQD),mxGetPr(FX),
       (int8_t *)mxGetData(OPY),mxGetPr(VY),mxGetScalar(DS),
       mxGetPr(FNQ),mxGetPr(F0),mxGetPr(F1),nV,nQ,nD,nr,nz);

 ASSIGN_PLHS;
}
