/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* IgNg = bfprmex(gNg) */

# define MEXNAME bfprmex

# define IGNG pout[0]

# define GNG  prhs[0]  /* double, def size=[nn,*], size=[nn,3] */

 CHECK_NARGIN_EQ(1);

 int nn = mxGetM(GNG);

 CHECK_DOUBLE(GNG);
 CHECK_NCOLS(GNG,3);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1] = {NULL};

 IGNG = mxCreateDoubleMatrix(nn,3,mxREAL);
 dbfpr(mxGetPr(IGNG),mxGetPr(GNG),nn);

 ASSIGN_PLHS;
}
