/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */

/*
 * bfefmex.c is a MEX-file for the C implementation of the bfef set
 *
 * See also: bfctmex.h bfef.c bfef.m
 */

# include "meq.h"

# define MEXNAME bfefmex

# include "bfctmex.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

  /* Declare potential output arguments */
  mxArray *pout[NARGOUT_MAX] = {NULL};

  /* Initial checks */
  bfctmex_init_checks(nlhs, pout, nrhs, prhs);

  /* Parameter checks */
  CHECK_DOUBLE(par);
  CHECK_NUMEL(par,2);

  /* Get parameters and number of basis functions */
  int nP = mxGetPr(par)[0],
      nT = mxGetPr(par)[1];
  int ng = nP+nT;

  /* Get fPg and fTg */
  double fPg[ng], fTg[ng];
  dbfef_fPg(nP, nT, fPg, fTg);

  /* Define parameter structure for bfef */
  bfef_params bfparams = {nP, nT};

  /* Define parameter structure for bfct */
  dbfct_params params = {ng, fPg, fTg, &bfparams, dbfef_f , dbfef_fN , dbfef_fag , dbfef_fA ,
                                                  dbfef_df, dbfef_dfN, dbfef_dfag, dbfef_dfA};

  /* Get mode value */
  int mode = mxGetScalar(MODE);

  /* Chinese menu */
  switch (mode) {
    case 6: {
      int nPq = nP>2 ? nP-2 : 0, nTq = nT>2 ? nT-2 : 0, nq = nPq + nTq + 2*(ng>0);

      /* Inputs checks */
      bfctmex_mode_6_checks_alloc(nlhs, pout, nrhs, prhs, ng, nq);

      /* Call bfef */
      dbfef6(mxGetPr(y1), mxGetPr(y2), mxGetScalar(FA), mxGetScalar(FB),
             mxGetScalar(q1), mxGetScalar(q2), mxGetScalar(q3), nP, nT, nq);
      break;
    }
    case 16: {
      int nPq = nP>2 ? nP-2 : 0, nTq = nT>2 ? nT-2 : 0, nq = nPq + nTq + 2*(ng>0);

      /* Inputs checks */
      bfctmex_mode_16_checks_alloc(nlhs, pout, nrhs, prhs, ng, nq);

      /* Call bfef */
      dbfef16(mxGetPr(y1), mxGetPr(y2), mxGetPr(y3), mxGetPr(y4),
              mxGetScalar(FA), mxGetScalar(FB), mxGetScalar(q1),
              mxGetScalar(q2), mxGetScalar(q3), nP, nT, nq);
      break;
    }
    default: {
      /* Call generic bfctmex */
      bfctmex(mode, &params, nlhs, pout, nrhs, prhs);
    }
  }

  ASSIGN_PLHS;
}
