function X = meqxfile(t,L)
% MEQXFILE - Input data for FILE
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

X = load(L.P.xfile);

%% Select time indices for our t array
if isempty(t), t=X.t; end
assert(~any( t>max(X.t) | t<min(X.t)),...
  'requested times [%4.2f,%4.2f] are out of range of available time [%4.2f,%4.2f]',...
      min(t),max(t),min(X.t),max(X.t));

% Interpolate
X = meqinterp(meqxk(X,1:numel(X.t)),t,L.P.interpmethod);


end
