function LX = meqx(L,LX)
% General LX quantities
% For help on most quantities, see help MEQT
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% reorder fields to have these first:
D.tokamak  = L.P.tokamak;
D.shot     = L.P.shot;

for field=fieldnames(D)'
  if ~isfield(LX,field{1})
    LX.(field{1}) = D.(field{1});
  end
end

if ~isfield(LX,'aq'), LX.aq = []; end
if ~isfield(LX,'aW'), LX.aW = []; end

firstfields = {'tokamak','shot','t'};
LX = orderfields(LX,[firstfields,setdiff(fieldnames(LX)',firstfields)]);

end