function meqsave(L,LX,varargin)
 % MEQSAVE Saves MEQ P,G,X structures to file
 %
 % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

 switch L.P.tok
   case 'file'
     % Save using filenames in P structure as defaults
     pfile = L.P.pfile;
     gfile = L.P.gfile;
     xfile = L.P.xfile;
   otherwise
     base = sprintf('%s_%d_%s',L.P.tok,L.P.shot,L.code);
     pfile = [base,'_P.mat'];
     gfile = [base,'_G.mat'];
     xfile = [base,'_X.mat'];
 end

 % Overwrite with function arguments
 for k = 1:2:numel(varargin)
   switch varargin{k}
     case 'pfile', pfile = varargin{k+1};
     case 'gfile', gfile = varargin{k+1};
     case 'xfile', xfile = varargin{k+1};
   end
 end

 % Assign structures to variables to enable saving
 P = L.P;
 G = L.G;
 if nargin>1 && ~isempty(LX)
   X = LX;
 else
   X = struct();
 end
 
 save(pfile,'-struct','P');
 save(gfile,'-struct','G');
 save(xfile,'-struct','X');

end
