function LYnew = meqreprocess(L,LY)
% Reprocess LY structure recomputing meqpdom and meqpost outputs
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

warnid = sprintf('%s:INACCURATE_PROFILE_FIT',upper(mfilename));

% Init aq, aW
aq = []; aW = [];

for kt = 1:numel(LY.t)
  LYt = meqxk(LY,kt);
  
  % find plasma domain
  [rA,zA,FA,dr2FA,dz2FA,drzFA,rX,zX,FX,dr2FX,dz2FX,drzFX,...
    rB,zB,FB,lB,lX,Opy,F0,F1,stat,msg,id] = meqpdom(LYt.Fx,LYt.Ip,L.P.isaddl,L);
  if ~stat
    meqmsge('e',mfilename,L.P.tok,LYt.t,NaN,LYt.shot,msg,id);
  end
  
  % refit ag basis function coefficients (should do always because basis
  % functions may have changed)
  assert(L.nD==1, 're-fit of P'' and TT'' for multiple domains not available')
  ag = meqfitprof(L,L.pQ.^2,LYt.FA,LYt.FB,LYt.PpQ,LYt.TTpQ);
 
  % post-processing
  LYtnew = struct('shot',LYt.shot,'t',LYt.t,'aq',aq,'aW',aW);
  
  LYtnew = meqpost(L,LYtnew,ag,...
    LYt.Fx,FA,FB,rA,zA,dr2FA,dz2FA,drzFA,rB,zB,lB,lX, ...
    rX,zX,FX,dr2FX,dz2FX,drzFX, ...
    LYt.rBt,LYt.Ia,LYt.Iu,LYt.Iy,Opy,F0,F1);
  
  % check p',TT' profile fits
  if ( norm(LYt.PpQ-LYtnew.PpQ  ) / (norm(LYtnew.PpQ ) + eps) ) > 1e-6
    warning(warnid,'inaccurate fit of PpQ, basis functions may not accurately represent equilibrium')
  end
  if ( norm(LYt.TTpQ-LYtnew.TTpQ) / (norm(LYtnew.TTpQ) + eps) ) > 1e-6
    warning(warnid,'inaccurate fit of TTpQ, basis functions may not accurately represent equilibrium')
  end
  
  % add eventual missing fields
  for field = fieldnames(LYt)'
    if ~isfield(LYtnew,field{:})
      LYtnew.(field{:}) = LYt.(field{:});
    end
  end

  % Fix Bm,Ff terms due to dz shift in liu
  if isfield(LY,'dz') && all(LY.dz~=0)
    LYtnew.Bm = LYtnew.Bm + LYtnew.dz*L.G.dzBmx(:,L.lxy)*LYtnew.Iy(:);
    LYtnew.Ff = LYtnew.Ff + LYtnew.dz*L.G.dzMfx(:,L.lxy)*LYtnew.Iy(:);
  end

  % Update aq, aW
  aq = LYtnew.aq; aW = LYtnew.aW;
  
  LYnews(kt) = LYtnew; %#ok<AGROW> % store in array of struct
end

% pack
LYnew = meqlpack(LYnews);

end


