function meqplotFx(L,LY,varargin)
%MEQPLOTFX minimal plot of flux surface
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

meqgplot(L.G); hold on;

if ~isempty(LY)
  assert(numel(LY.t)==1,'can plot only one time slice')
  if ~isfield(LY,'FB')
    f = 31;
  else
    f = LY.FA + (LY.FB-LY.FA)*linspace(-1,1,31);
  end
  contour(L.rx,L.zx,LY.Fx,f,varargin{:});
end
axis equal;
end
