function P = meqpfile(~,varargin)
 % Default parameters for file tokamak
 % 
 % pfile
 % gfile
 % xfile
 %
 % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

 % Load pfile specified in input
 for k = 1:2:numel(varargin)
   if strcmp(varargin{k},'pfile')
     P = load(varargin{k+1});
     break
   end
 end

 % Defaults
 P.tok = 'file';
 P.pfile = '';
 P.gfile = '';
 P.xfile = '';

 % Overwrites
 for k = 1:2:numel(varargin)
   P.(varargin{k}) = varargin{k+1};
 end

end
