%MEQP  MEQ default algorithm configuration parameters
% P = MEQP defines default algorithm configuration parameters common to
% MEQ.
%
%%
% .tokamak      Full name of tokamak
% .tok          Short name of tokamak
% .shot         #shotnum
% .dasm         Minimal distance (grid points) between X and axis points [asxy]
% .lasy         Search axes and X-points also outside the limiter contour
% .xdoma        Angle of X-point polygon edges with perpendicular (>0 values to get a smaller polygon) [pdom]
% .isaddl       If ~isaddl, ignore X-points when searching LCFS
% .ilim         If 0, ignore limiter when searching LCFS. If 1, use limiter points, if 2, use quadratic interpolation, if 3: cubic splines (requires icsint) 
% .idoublet     If idoublet, allow doublet equilibria
% .ihole        If ihole (default), allow axes with current densities opposite to Ip when multiple axes are found
% .r0           default major radius used for outputs/normalizations
% .b0           default toroidal field used for outputs/normalizations
% .pq           If not empty provides user-defined radial grid (excl LCFS and axis)
% .pqu          maximum rho-psi for radial grid                   [active only if pq is empty]
% .pql          minimum rho-psi for radial grid                   [active only if pq is empty]
% .npq          number of radial grid points (excl LCFS and axis) [active only if pq is empty]
% .noq          size of theta-grid mesh for contours
% .raS          r/a values of flux surfaces for which to return r,z, coordinates
% .ri       [m] Inner boundary of computational grid                       [active only if selx is empty for TCV]
% .ro       [m] Outer boundary of computational grid                       [active only if selx is empty for TCV]
% .zl       [m] Lower boundary of computational grid                       [active only if selx is empty for TCV]
% .zu       [m] Upper boundary of computational grid                       [active only if selx is empty for TCV]
% .nr           Set radial grid points, true grid will be of size nr+1     [active only if selx is empty for TCV]
% .nz           Set vertical grid points, true grid will be of size 2*nz+1 [active only if selx is empty for TCV]
% .selu         Generalized vessel description selector string e.g. 's','e','v';
% .nu           Number of vessel variables (eigenmodes, segments)
%
% .cde          CDE used (also includes static CDEs for fgs), empty for no
%               cde, otherwise string or function handle for cde type
%
% .ilackner     flag for boundary flux computation in meqfbp: 0: use Mby*Iy 1: use Lackners trick, 2: Use a precomputed Mby representing Lackners trick
%
% .nFW          Number of fluxes to track for wall gaps. >1 gives secondary separatrices
% .rn       [m] Radial coordinate for points for flux, field interpolations
% .zn       [m] Z coordinate for points for flux, field interpolations
% .bfct         Basis function handle
% .bfp          Basis function parameters
%
% .infct        Interpolation function handle
% .inp          Interpolation function parameters
%
% .interpmethod Interpolation method for data (default: nearest)
% .iterq        Iterations of contour algorithm, enables contour-dependent calculations
% .tolq         Tolerance for convergence of contour algorithm, normalized to the radial grid size
% .iqR          Value of 1/q for which to return r/a location (only if iterq>0)
% .naR          Number of occurrences of each 1/q surfaces to track (size of raR will be [nR,naR])
% .ifield       Calculate Br,Bz fields as additional outputs
% .ivacuum      Calculate vacuum fluxes and fields Br0x, Bz0x, F0x (excluding plasma contribution)
% .izgrid       Additional 'z' grid for post-processing flux, field calculations
% .izxoverlap   Force partial overlapping of z and x grids, allows re-use of Fx in Fz
% .relax        Relaxation parameter for SQP and Newton methods
%
% .Ipmin        Minimum plasma current for which GS solution will be attempted
%
% .icsint       If icsint, use cubic spline interpolation for domain id. and contouring (default: false)
% .tolcs        Tolerance on position of axes, saddle points, limiter points                        [active only if icsint is true]
% .itercs       Maximum number of Newton-Raphson iterations for asxycs/flcs                         [active only if icsint is true]
% .nthreadscs   Maximum number of threads to be used in bspsum MEX-file for cubic spline evaluation [active only if icsint is true]
%
% .mdsserver    MDS server hostname for parameters/measurements loading
%
% .gsxe         Switch for treatment of external currents inside computational grid
% .gsxetol      Tolerance for mapping of external currents inside computational grid to y grid (when gsxe=2)
% .gfile        If non-empty, attempt to load geometry data from this file (see meqgload/meqgsave)
% .LYall        If true, LY contains all time slices, converged or not
%
% .ohcoils      Names of coils used for driving Ohmic current (from G.dima)
% .compcoils    Names of coils used for compensation of stray fields from Ohmic transformer coils
% .ohequal     Force currents of coils for OH induction to be equal
%
% .debug        debug flag
% .debugplot    level of debug plotting
% .debugfail    trigger extra debugging upon encontering failed slices/equilibria
% .argout       Additional output arguments (syntax: '[file:]fld[=exp]')
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.


function D = meqp
 D.tokamak      = '';
 D.tok          = '';
 D.shot         = [];

 D.debug        = 0 ;
 D.dasm         = 2 ;
 D.idoublet     = false;
 D.lasy         = false;
 D.isaddl       = 1; 
 D.ilim         = 1;
 D.ihole        = true;
 D.xdoma        = 0;
 
 D.ilackner     = 1;
 
 D.cde          = [];

 D.r0           = 1;
 D.b0           = 1;

 D.pq           = [];
 D.pqu          = sqrt(0.95);
 D.pql          = 0.2;
 D.raS          = [];
 D.npq          = 18;
 D.noq          = 32;
 D.ndom         = NaN;
 
 D.zl           = NaN;
 D.zu           = NaN;
 D.ri           = NaN;
 D.ro           = NaN;
 D.nr           = NaN;
 D.nz           = 32;

 D.selu         = 'v';
 D.nu           = [];
 
 D.bfct         = @bfabmex;
 D.bfp          = [1 2]; 
 
 D.nFW          = 1;
 D.infct        = [];
 D.inp          = [];
 D.rn           = [];
 D.zn           = [];
 D.iterq        = 0;
 D.tolq         = 1e-3;
 D.iqR          = [];
 D.naR          = 1;
 D.interpmethod = 'nearest';
 D.izgrid       = false;
 D.izxoverlap   = false;
 D.ifield       = false;
 D.ivacuum      = false;
 
 D.Ipmin        = 0; 
 
 D.gsxe         = 2;    % Treat external currents inside the grid exactly
 D.gsxetol      = 0;    % Do not drop any external currents on the computational grid
 D.relax        = 0;    % No relaxation

 D.icsint       = false;
 D.tolcs        = 1e-4;
 D.itercs       = 20;
 D.nthreadscs   = 2;

 D.ohcoils      = ''; % Names of coils used for driving Ohmic current
 D.compcoils    = ''; % Names of coils used for compensation of stray fields
 D.ohequal      = false; % Force currents of coils for OH induction to be equal

 D.gfile        = '';
 D.LYall        = true;
 
 D.debug        = 0;   % debug information
 D.debugplot    = 0;   % debug plotting level
 D.debugfail    = 0;   % debug failures
 D.argout       = {};
 
 D.signeodflt   = 1e7; % Default scaling value for signeo signeo = (1-0.9*L2.pQ')*P.signeodflt
end
