%MEQMDSSERVER Get and set MDS server
% server = meqmdsserver(newserver)
%
% Change the MDS server eg: meqmdsserver('myhost.mynet.my:8000');
% If no parameter given, returns the present name eg: name = meqmdsserver()
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

function server = meqmdsserver(newserver)
  persistent meq_mds_server;
  if nargin>0
    meq_mds_server = newserver;
  else
    if (isempty(meq_mds_server))
      meq_mds_server = 'tcvdata.epfl.ch';
    end
  end
  server = meq_mds_server;
end
