function [dIpQdag,dWkQdag,dWpQdag,dFtQdag,dIpQdFx,dWkQdFx,dWpQdFx,dFtQdFx,...
          dIpQdF0,dWkQdF0,dWpQdF0,dFtQdF0,dIpQdF1,dWkQdF1,dWpQdF1,dFtQdF1] = ...
          meqintQJac(L,F0,F1, rBt , ag, Fx, Opy)
%MEQINTQJAC Computes jacobian of meqintQ outputs
% [dIpQdag,dIpQdFx,dIpQdF0,dIpQdF1,dWkQdag,dWkQdFx,dWkQdF0,dWkQdF1,...
%           dWpQdag,dWpQdFx,dWpQdF0,dWpQdF1,dFtQdag,dFtQdFx,dFtQdF0,dFtQdF1] = ...
%           meqintQJac(L,F0,F1, rBt , ag, Fx, Opy)
% see MEQINTQ
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

dWpQdag  = zeros(L.nQ,L.nD,L.ng);
dWpQdFx  = zeros(L.nQ,L.nD,L.nx);
dWpQdF0  = zeros(L.nQ,L.nD,L.nD);
dWpQdF1  = zeros(L.nQ,L.nD,L.nD);
dIpQdFx  = dWpQdFx;
dWkQdFx  = dWpQdFx;
dFtQdFx  = dWpQdFx;

% Check Opy
Opy(Opy>L.nD) = 0;

% Normalized flux grid
FQ = L.pQ.^2;

% r and 1/r on y grid
rry = L.rry(:);
irry = 1./rry;
masky = (Opy(:)>0);
rry =   rry.*masky;
irry = irry.*masky;

% For d[Ip/Wk/Ft]dag integrands
[G,IG] = L.bfct(91,L.bfp,Fx(2:end-1,2:end-1),F0,F1);
% Combine with r or 1/r
fac = (rry.*L.fPg.' + irry.*L.fTg.');
fac = fac.*L.TDg(max(1,Opy(:)),:); % Deselect basis functions that are inactive in certain domains
Tyg  = fac.* G;
ITyg = fac.*IG;

% Here we define each integrand for cizrmex
Vy = zeros(L.ny,3*(L.ng+L.nD+L.nD));
iV = 0;
Vy(:,iV+(1:L.ng)) = Tyg*L.idsx;                   iV = iV + L.ng; % dIpQdag
Vy(:,iV+(1:L.ng)) = ITyg.*L.fPg'*1.5*L.idsx;      iV = iV + L.ng; % dWkQdag
Vy(:,iV+(1:L.ng)) = ITyg.*L.fTg'*2e-7/rBt*L.idsx; iV = iV + L.ng; % dFtQdag

% For d[Ip/Wk/Ft]d[Fx/F0/F1]
[dGdFy,dGdF0,dGdF1,dIGdFy,dIGdF0,dIGdF1] = L.bfct(92,L.bfp,Fx(2:end-1,2:end-1),F0,F1);
dTygdFy  = fac.* dGdFy;
dTygdF0  = fac.* dGdF0;
dTygdF1  = fac.* dGdF1;
dITygdFy = fac.*dIGdFy;
dITygdF0 = fac.*dIGdF0;
dITygdF1 = fac.*dIGdF1;

dIpdFy =  dTygdFy*        ag;
dWkdFy = dITygdFy*(L.fPg.*ag)*1.5;
dFtdFy = dITygdFy*(L.fTg.*ag)*2e-7/rBt;
dIpdF0 = reshape(sum( dTygdF0.*        ag .'         ,2),[L.ny,L.nD]);
dWkdF0 = reshape(sum(dITygdF0.*(L.fPg.*ag).'*1.5     ,2),[L.ny,L.nD]);
dFtdF0 = reshape(sum(dITygdF0.*(L.fTg.*ag).'*2e-7/rBt,2),[L.ny,L.nD]);
dIpdF1 = reshape(sum( dTygdF1.*        ag .'         ,2),[L.ny,L.nD]);
dWkdF1 = reshape(sum(dITygdF1.*(L.fPg.*ag).'*1.5     ,2),[L.ny,L.nD]);
dFtdF1 = reshape(sum(dITygdF1.*(L.fTg.*ag).'*2e-7/rBt,2),[L.ny,L.nD]);

% ... continue filling Vy
Vy(:,iV+(1:L.nD)) = dIpdF0*L.idsx;                iV = iV + L.nD; % dIpQdF0
Vy(:,iV+(1:L.nD)) = dWkdF0*L.idsx;                iV = iV + L.nD; % dWkQdF0
Vy(:,iV+(1:L.nD)) = dFtdF0*L.idsx;                iV = iV + L.nD; % dFtQdF0
Vy(:,iV+(1:L.nD)) = dIpdF1*L.idsx;                iV = iV + L.nD; % dIpQdF1
Vy(:,iV+(1:L.nD)) = dWkdF1*L.idsx;                iV = iV + L.nD; % dWkQdF1
Vy(:,iV+(1:L.nD)) = dFtdF1*L.idsx;                                % dFtQdF1

% Perform integration
IVQD = cizrmex(Fx,Opy,Vy,L.dsx,FQ,F0,F1);

% Dispatch
iV = 0;
dIpQdag = IVQD(:,:,iV+(1:L.ng)); iV = iV + L.ng;
dWkQdag = IVQD(:,:,iV+(1:L.ng)); iV = iV + L.ng;
dFtQdag = IVQD(:,:,iV+(1:L.ng)); iV = iV + L.ng;
dIpQdF0 = IVQD(:,:,iV+(1:L.nD)); iV = iV + L.nD;
dWkQdF0 = IVQD(:,:,iV+(1:L.nD)); iV = iV + L.nD;
dFtQdF0 = IVQD(:,:,iV+(1:L.nD)); iV = iV + L.nD;
dIpQdF1 = IVQD(:,:,iV+(1:L.nD)); iV = iV + L.nD;
dWkQdF1 = IVQD(:,:,iV+(1:L.nD)); iV = iV + L.nD;
dFtQdF1 = IVQD(:,:,iV+(1:L.nD));

% Derivatives with respect to Fx
%  These could be handled by adding many more colums to Vy but this is not
%  really efficient

% Compute mapping from y grid to Q grid
iQy = zeros(L.ny,1);
Fy = Fx(2:end-1,2:end-1);
for iD = 1:L.nD
  if F1(iD) == F0(iD), continue; end
  FNy = (Fy - F0(iD))./(F1(iD) - F0(iD));
  mask = Opy(:) == iD;
  iQy(mask) = iceil(FQ,FNy(mask),1);
end
ix = find(L.lxy);

% d[Ip/Wk/Ft]dFx
ind = max(1,iQy) + (double(max(1,Opy(:)))-1)*L.nQ + (ix-1)*(L.nQ*L.nD);
dIpQdFx(ind) = dIpdFy;
dWkQdFx(ind) = dWkdFy;
dFtQdFx(ind) = dFtdFy;
dIpQdFx = cumsum(dIpQdFx);
dWkQdFx = cumsum(dWkQdFx);
dFtQdFx = cumsum(dFtQdFx);

% For dWpdFx

% Compute flux gradient on y grid
dFdr = (Fx(2:end-1,3:end) - Fx(2:end-1,1:end-2))/2/L.drx;
dFdz = (Fx(3:end,2:end-1) - Fx(1:end-2,2:end-1))/2/L.dzx;

dFdr = dFdr(:) .* masky .* irry ./ L.drx;
dFdz = dFdz(:) .* masky .* irry ./ L.dzx;

indt = max(1,iQy) + (double(max(1,Opy(:)))-1)*L.nQ + (ix        )*(L.nQ*L.nD); % Top
indb =                                        indt + (  -2      )*(L.nQ*L.nD); % Bottom
indr =                                        indt + (  +L.nzx-1)*(L.nQ*L.nD); % Right
indl =                                        indt + (  -L.nzx-1)*(L.nQ*L.nD); % Left
dWpQdFx(indt) =               + dFdz;
dWpQdFx(indb) = dWpQdFx(indb) - dFdz;
dWpQdFx(indr) = dWpQdFx(indr) + dFdr;
dWpQdFx(indl) = dWpQdFx(indl) - dFdr;

dWpQdFx = L.dsx/(4*pi*4e-7*pi) * cumsum(dWpQdFx);

end
