function LY = meqik(LY,k,LX)
%MEQIK Insert time slice into LX/LY structure
%
% LY = meqik(LY,k,LX)
%  Inserts LX slice(s) into LY starting at index k;
%  LX can have an arbitrary number of times.
%  All data is inserted after index k
%  k must be a scalar or a logical index with one true entry
%  As this uses meqlpack, arrays are padded with NaNs when necessary
%
%
%  See also MEQXK, MEQSK, MEQLPACK
%
%  [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

assert( islogical(k)&&(sum(k)==1) || (numel(k)==1),'k must be scalar or a logical index with only one true entry')
fieldnamediff = setdiff(fieldnames(LY),fieldnames(LX));
assert( isempty(fieldnamediff),'meqik:NotSameFields',...
  'Structures must have the same fields for insertion using meqik.');

% unpack LY
LYu = repmat(meqxk(LY,1),1,numel(LY.t)); % init
for ii=2:numel(LY.t)
  LYu(ii) = meqxk(LY,ii);
end

% unpack LX
LXu = repmat(meqxk(LX,1),1,numel(LX.t)); % init
for ii=2:numel(LX.t)
  LXu(ii) = meqxk(LX,ii);
end

% Insert LX starting at index k
LYu = [LYu(1:k-1),LXu,LYu(k:end)];

% pack
LY = meqlpack(LYu);
if isfield(LX,'tokamak')
  LY.tokamak = LX.tokamak;
end

end
