function [Parel,Palarm] = meqetcv(G,Ia)
% [Parel,Palarm] = meqetcv(Ia,G)
% Implements coil equation constraints for TCV
% Parel: Relative violation of protection equation
% Palarm: Boolean signalling violation
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% TCV case only for now
Ieq = (G.Ceq*Ia);
Ioh2(G.Seq~=1,:) = 1;
Ioh2(G.Seq==1,:) = Ia(contains(G.dima,'OH_002'));
Iprot = Ieq.*Ioh2;
Parel = zeros(size(Iprot));
ip = Iprot>=0;
Parel( ip) = Iprot( ip)./G.Ihig( ip);
Parel(~ip) = Iprot(~ip)./G.Ilow(~ip);

Palarm = (Iprot > G.Ihig | Iprot < G.Ilow);

end
