function meqdiff(LY1,LY2,diffvars)
% MEQDIFF textual display of differences between two similar equilibria
%
% meqdiff(LY1,LY2[,diffvars])
% LY1,LY2: two MEQ equilibrium structires with a single time slice
% diffvars: optional cell array of LY fields to compare
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if nargin==2
  diffvars = {'Ip','Vp','Wk','li','rA','zA','qA','FA','FB','rX','zX','FX'};
end

assert(numel(LY1.t)==1 && numel(LY2.t)==1,...
  'can only handle single time slices, use meqxk() to slice');

fprintf('\rmeqdiff: eq1: #%d t=%g   eq2: #%d t=%g\n',LY1.shot,LY1.t,LY2.shot,LY2.t)
fprintf('       eq1         eq2\n')

for var=diffvars
  printdiff(LY1,LY2,var{:});
end

end

function printdiff(LY1,LY2,myvar)
v1 = LY1.(myvar);
v2 = LY2.(myvar);
if numel(v1) ~= numel(v2)
  fprintf('%s: different size, can not display\n',myvar);
else
  err = v2-v1;
  perr = err./v1*100;
  if numel(v1)==1
    fprintf('%s   : %+6.3e  %+6.3e  diff: %+6.3e (%+6.4f%%)\n',...
      myvar,v1,v2,err,perr);
  else
    for ii=1:numel(v1)
      fprintf('%s(%d): %+6.3e  %+6.3e  diff: %+6.3e (%+6.4f%%)\n',...
        myvar,ii,v1(ii),v2(ii),err(ii),perr(ii));
    end
  end
end
end
