function LY = meqcat(LY,varargin)
% MEQCAT concatenate MEQ data structures
%
% LY = meqcat(LY,LY2[,LY3])
% Concatenates LY structures appending LY2 after LY.
% Multiple LY structures can be concatenated at the same time by passing
% more arguments.
%
% See also MEQIK
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

for ii=1:numel(varargin)
  LYii = varargin{ii};
  if ~(isempty(LYii) || (isstruct(LYii) && isfield(LYii,'t')))
    error('meqcat:inputStruct','inputs to meqcat must be structures with a "t" field');
  end
  if isempty(LYii) || isempty(LYii.t)
    continue; % empty slice, don't cat
  end
  k = numel(LY.t)+1; % insert after last one
  LY = meqik(LY,k,LYii);
end

end
