function [dYDgdFy,dYDgdF0,dYDgdF1,dYDgdFx] = meqbfct1Jac(L,nB,Opy,dYygdFy,dYygdF0,dYygdF1,dF0dFx,dF1dFx)
% MEQBFCT1JAC Assembles analytical gradient of YDg, where YDg is any one of TpDg|ITpDg, with respect to Fy,F0,F1 and total Fx
%
%   [dYDgdFy,dYDgdF0,dYDgdF1,dYDgdFx] = meqbfct1Jac(L,nB,Opy,dYygdFy,dYygdF0,dYygdF1[,dF0dFx,dF1dFx])
%
% Evaluation of dYDgdFx requires the presence of dF0dFx and dF1dFx.
%
% See also MEQIYJAC
%  
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Jacobians for TpDg, ITpDg
dYDgdFy = zeros(L.nD,L.ng,L.ny);
dYDgdF0 = zeros(L.nD,L.ng,L.nD);
dYDgdF1 = zeros(L.nD,L.ng,L.nD);
for iD = 1:nB
  maskD = Opy(:) == iD;
  dYDgdFy(iD,:,:) =            (dYygdFy.*maskD).';
  dYDgdF0(iD,:,:) = reshape(sum(dYygdF0.*maskD,1),L.ng,L.nD);
  dYDgdF1(iD,:,:) = reshape(sum(dYygdF1.*maskD,1),L.ng,L.nD);
end
% Join first 2 dimensions for matrix product compatibility
dYDgdFy  = reshape( dYDgdFy,L.nD*L.ng,L.ny);
dYDgdF0  = reshape( dYDgdF0,L.nD*L.ng,L.nD);
dYDgdF1  = reshape( dYDgdF1,L.nD*L.ng,L.nD);

if nargout>3
  % construct total Fx derivative
  if nargin<8
    error('Computing dYDgdFx requires dF0dFx/dF1dFx');
  end
  % Use full matrix
  dYDgdFx = zeros(L.nD*L.ng,L.nx);
  % dYDgdFy
  dYDgdFx(:,L.lxy) = dYDgdFy;
  % dYDgd[F0/F1]
  dYDgdFx = dYDgdFx + dYDgdF0*dF0dFx + dYDgdF1*dF1dFx;
end

end
