/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meqh.h"
void FLT_CBLAS(gemv)(const CBLAS_LAYOUT Layout, const CBLAS_TRANSPOSE trans, 
                     const int m, const int n, const FLT alpha, const FLT *a, const int lda,
                     const FLT *x, const int incx, const FLT beta, FLT *y, const int incy)
{
 ptrdiff_t m_, n_, lda_, incx_, incy_;
 char * tr = trans == CblasNoTrans ? "N" : (trans == CblasTrans ? "T" : "C");
 m_ = m; n_ = n; lda_ = lda; incx_ = incx; incy_ = incy;
 FLT_BLAS(gemv)(tr, &m_, &n_, &alpha, a, &lda_, x, &incx_, &beta, y, &incy_);
}
