/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meqh.h"

void FLT_CBLAS(gemm)(const CBLAS_LAYOUT Layout, const CBLAS_TRANSPOSE transa, const CBLAS_TRANSPOSE transb, 
                     const int m, const int n, const int k, const FLT alpha, const FLT *a, const int lda,
                     const FLT *b, const int ldb, const FLT beta, FLT *c, const int ldc)
{
 ptrdiff_t m_, n_, k_, lda_, ldb_, ldc_;
 char * ta = transa == CblasNoTrans ? "N" : (transa == CblasTrans ? "T" : "C");
 char * tb = transb == CblasNoTrans ? "N" : (transb == CblasTrans ? "T" : "C");; 
 m_ = m; n_ = n; k_ = k; lda_ = lda; ldb_ = ldb; ldc_ = ldc;
 FLT_BLAS(gemm)(ta, tb, &m_, &n_, &k_, &alpha, a, &lda_, b, &ldb_, &beta, c, &ldc_);
}
