%LOCRMEX  Location of q surfaces
% [AR] = LOCRMEX(AQ,QQ,QR,NAR,NF) returns the location of the flux surfaces where
% QR=QQ(AQ==AR)
%
% AQ: x data
% QQ: y data
% QR: Requested y values
% NAR: (optional) Number of maximum R values to be found (per QR) for nonmonotonic profiles.
%          (default=1: outermost value found)
% NF: (optional) AR = NF signals the q value was not found
%
% AR: interpolated x data
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

function aR = locRmex(aQ,qQ,qR,varargin)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 
 aR = locRmexm(aQ,qQ,qR,varargin{:});
 
end
