function X = liuxana(shot,t,L)
% LIUXANA - Input data for ANAMAK
% run FBT to get liuqe input data for anamak
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

fields_to_rm = {'iterq','algoNL','fastcoil','Ipmin','cde','argout',...
  'jacobian_handle','jacobian_sparse','algoGMRES','userowmask',...
  'mkryl','usepreconditioner','itert'};
P = rmfield(L.P,fields_to_rm(isfield(L.P,fields_to_rm)));
PP = [fieldnames(P),struct2cell(P)]';          % pass L parameters as fbt inputs
[Lb,~,LYb] = fbt('ana',shot,[],PP{:});         % input time is arbitrary for fbtana (one equilibrium)

assert(~isempty(LYb),'fbt did not converge for anamak shot %d',shot)
if isempty(t), t=LYb.t; end

% Adjust time base
LYb = meqinterp(LYb,t,'nearest');
LYb.t = t;
X = meqxconvert(Lb,LYb,L,true); % Return minimal LX
end
