%LIUX  LIUQE diagnostic measurements
% LX = LIUX<TOK>(SHOT,T,L) returns a structure with diagnostic measurements
% at time T for SHOT
%
% .t     [s] (t)   Time base
% .Ff   [Wb] (:,t) Flux loop flux
% .Bm    [T} (:,t) Magnetic probes
% .Ia    [A} (:,t) Active coil currents
% .Uf    [V] (:,t) Flux loop voltage
% .Ft   [Wb] (1,t) Diamagnetic flux
% .Xt   [Wb] (1,t) Diamagnetic flux measurement (excludes Iy correction)
% .rBt [m T] (1,t) Vaccum toroidal field *r
% .Is    [A] (:,t) Vessel segment current
% .Ip    [A] (1,:) Plasma current from discrete Rogowski
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function LX = liux(L,LX)
LX = meqx(L,LX);

% Diamagnetic flux measurement
if ~isfield(LX,'Xt')
  if any(L.Mty)
    warning('liux:noXt','DML has Iy compensation term L.Mty but no Xt measurement was provided, using Ft directly');
  end
  LX.Xt = LX.Ft;
end
end